<?php

declare(strict_types=1);

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Define the base path to your backend folder (outside public_html)
define('BASE_PATH', '/home/webworks/payr-backend');

// Load Composer autoloader
require_once BASE_PATH . '/vendor/autoload.php';

// Load environment variables
$dotenv = Dotenv\Dotenv::createImmutable(BASE_PATH);
$dotenv->load();

// Set timezone
date_default_timezone_set('Africa/Harare');

// CORS Headers
header('Access-Control-Allow-Origin: ' . ($_ENV['CORS_ALLOWED_ORIGINS'] ?? '*'));
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Content-Type: application/json; charset=UTF-8');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Initialize application
use App\Core\Router;
use App\Core\Database;
use App\Utils\Logger;

try {
    // Initialize logger
    $logger = Logger::getInstance();
    $logger->info('Application started', ['method' => $_SERVER['REQUEST_METHOD'], 'uri' => $_SERVER['REQUEST_URI']]);
    
    // Test database connection
    $db = Database::getInstance();
    
    // Initialize router
    $router = new Router();
    
    // Load routes
    require_once BASE_PATH . '/src/routes.php';
    
    // Dispatch request
    $router->dispatch();
    
} catch (\Exception $e) {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => $_ENV['APP_DEBUG'] === 'true' ? $e->getMessage() : 'Internal server error',
        'timestamp' => date('c')
    ]);
    
    if (isset($logger)) {
        $logger->error('Application error: ' . $e->getMessage(), ['trace' => $e->getTraceAsString()]);
    }
}
